<?php

namespace App\Http\Controllers;

use App\Movie;
use App\MovieVideo;
use BackblazeB2\Client;
use BackblazeB2\Bucket;
use Illuminate\Support\Str;

class ProcessarLinkB2Controller extends Controller
{
    public function syncFilesWithDB()
    {
        // Inicializar Backblaze
        $client = new Client('8ec7019561e0', '005209eb9e555e4004a5e19656db28829fb669b3a7');
        $buckets = $client->listBuckets();
        $files = $client->listFiles(['BucketId' => 'd85e2ca7800119c586810e10']);

        // Percorrer cada arquivo no Backblaze
        foreach ($files as $file) {
            $fileName = $file->getName();

            $normalizedMovieName = $this->normalizeMovieName($fileName);

            $matchingMovies = Movie::where('title', $normalizedMovieName)->get();

            if ($matchingMovies->isEmpty()) {
                $matchingMovies = Movie::search($normalizedMovieName)->get();
            }


            if ($matchingMovies->count() > 1) {
                // Registrar um erro ou fazer algo para lidar com isso
            }

            if ($matchingMovies->count() === 1) {
                $matchingMovie = $matchingMovies->first();
                // ... (resto do código para atualizar o link)
            }
            

            // dump("Filmes correspondentes para | $normalizedMovieName: ", $matchingMovies->pluck('title'));

            $bestMatch = null;

            foreach ($matchingMovies as $matchingMovie) {
                $movieNameFromDB = strtolower($matchingMovie->title);
                // dump("Comparando: $normalizedMovieName com | ". $matchingMovie->title);
                if ($this->areMovieNamesSimilar($normalizedMovieName, $movieNameFromDB, strtolower($matchingMovie->original_name), $movieYear, $movieYearFromDB)) {
                    $bestMatch = $matchingMovie;
                    break; // Se encontrarmos uma correspondência perfeita, saímos do loop
    
                } else {
                    // Adicione esta linha para depuração
                    // dump("Não são similares: $normalizedMovieName | $movieNameFromDB");
                }
            }

            if ($bestMatch) {
                // Remover todos os vídeos existentes para o filme
                $bestMatch->videos()->delete();

                $downloadUrl = "https://v.baixarfree.com";
                $bucketName = "gmutxflix";
                $fileName = $fileName;

                $fileUrl = "$downloadUrl/file/$bucketName/$fileName";
        
                $movieVideo = new MovieVideo([
                    'link' => $fileUrl,
                    'server' => 'Servidor 1',
                ]);
        
                $bestMatch->videos()->save($movieVideo);
            }
        }


        return redirect()->route('sync-files')->with('status', 'Sincronização completa');
    }


    private function areMovieNamesSimilar($name1, $name2, $year1, $year2)
{
    // Normalizar as strings antes da comparação
    $name1 = $this->normalizeMovieName($name1);
    $name2 = $this->normalizeMovieName($name2);

    // dump("Entrando na função areMovieNamesSimilar com $name1 e $name2");

    // 1. Verificação de igualdade direta
    if ($name1 == $name2) {
        return true;
    }

    if (Str::contains($name1, $name2) || Str::contains($name2, $name1)) {
        return true;
    }

    if (is_numeric($name1) && is_numeric($name2)) {
        return $name1 == $name2 && $year1 == $year2;
    }

    if ($name1 == $name2 && $year1 == $year2) {
        return true;
    }

    // 2. Comparação de Similaridade de Strings usando similar_text
    $similarity = similar_text($name1, $name2, $percent);
    if ($percent > 90) {
        return true;
    }

    // 3. Comparação de Similaridade de Strings usando Jaro-Winkler
    $jaroWinklerSimilarity = $this->jaroWinklerSimilarity($name1, $name2);
    if ($jaroWinklerSimilarity > 0.85) { // Ajuste o limite conforme necessário
        return true;
    }

    // 4. Comparação de palavras-chave
    $keywords1 = $this->extractKeywords($name1);
    $keywords2 = $this->extractKeywords($name2);
    $matchingKeywords = array_intersect($keywords1, $keywords2);
    $totalKeywords = count(array_unique(array_merge($keywords1, $keywords2)));

    if ($totalKeywords == 0) {
        return false;
    }

    $differentKeywords = array_diff($keywords1, $keywords2);
    if (count($differentKeywords) > 1) { // Se houver mais de uma palavra-chave diferente, retorne false
        return false;
    }

    $matchingPercentage = count($matchingKeywords) / $totalKeywords;

    if ($matchingPercentage > 0.1 && count($matchingKeywords) > 1) {
        return true;
    }

    return false;
}

private function jaroWinklerSimilarity($str1, $str2) {
    $jaro = $this->jaroSimilarity($str1, $str2);
    $prefixLength = $this->getPrefixLength($str1, $str2);

    return $jaro + ($prefixLength * 0.1 * (1 - $jaro));
}

private function jaroSimilarity($str1, $str2) {
        $len1 = strlen($str1);
        $len2 = strlen($str2);

        if ($len1 == 0 || $len2 == 0) {
            return 0;
        }

        $matchDistance = (int) floor(max($len1, $len2) / 2) - 1;
        $matches1 = array_fill(0, $len1, false);
        $matches2 = array_fill(0, $len2, false);
        $matches = 0;
        $transpositions = 0;

        for ($i = 0; $i < $len1; $i++) {
            $start = max(0, $i - $matchDistance);
            $end = min($i + $matchDistance + 1, $len2);

            for ($j = $start; $j < $end; $j++) {
                if ($matches2[$j]) continue;
                if ($str1[$i] != $str2[$j]) continue;
                $matches1[$i] = true;
                $matches2[$j] = true;
                $matches++;
                break;
            }
        }

        if ($matches == 0) {
            return 0;
        }

        $k = 0;
        for ($i = 0; $i < $len1; $i++) {
            if (!$matches1[$i]) continue;
            while (!$matches2[$k]) $k++;
            if ($str1[$i] != $str2[$k]) $transpositions++;
            $k++;
        }

        return (($matches / $len1) + ($matches / $len2) + (($matches - $transpositions / 2) / $matches)) / 3;
    }

    private function getPrefixLength($str1, $str2, $maxPrefixLength = 4) {
        $n = min(min(strlen($str1), strlen($str2)), $maxPrefixLength);
        for ($i = 0; $i < $n; $i++) {
            if ($str1[$i] != $str2[$i]) {
                return $i;
            }
        }
        return $n;
    }



    private function extractKeywords($name)
    {
        $words = explode(' ', $name);
        $keywords = [];

        // Lista de palavras a serem ignoradas
        $ignoreWords = ['o', 'a', 'os', 'as', 'um', 'uma', 'do', 'da', 'dos', 'das', 'e', 'de', 'la', 'el', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'];

        foreach ($words as $word) {
            if (!in_array($word, $ignoreWords) && strlen($word) > 2) {
                $keywords[] = $word;
            }
        }

        return $keywords;
    }




    // Função para extrair o nome e o ano do título do arquivo txt
    private function extractNameAndYear($titleWithYear)
    {
        if (is_numeric($titleWithYear)) {
            return [$titleWithYear, null];
        }
        // Assume que o ano está sempre no final e é precedido por um espaço
        if (preg_match('/(.*\D)\s*(\d{4})$/', $titleWithYear, $matches)) {
            $movieName = trim($matches[1]);
            $movieYear = (int)$matches[2];
            return [$movieName, $movieYear];
        }
        return [$titleWithYear, null];
    }

    // Função para normalizar o nome do filme (remover caracteres especiais, números, etc.)
    private function normalizeMovieName($name)
    {
        // Divide o nome em palavras
        $words = explode(' ', $name);

        if (is_numeric($name)) {
            return $name;
        }

        // Verifica se a última palavra é um número
        if (is_numeric(end($words))) {
            // Aqui você pode ajustar o nome do filme conforme necessário
            // Por exemplo, você pode simplesmente remover a última palavra (o número da sequência)
            array_pop($words); // Remove a última palavra
            $name = implode(' ', $words); // Junta as palavras novamente
        }

        // Substitui caracteres especiais por espaços
        $name = str_replace(['mp4','-','[',']', ':', '..', '...', '!', '?', '(', ')', '.', '=','+','/'], ' ', $name);

        // Substitui múltiplos espaços por um único espaço
        $name = preg_replace('/\s+/', ' ', $name);

        // Converte para minúsculas
        return Str::lower(trim($name));
    }


}
