<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Laravel\Passport\Client;
use Illuminate\Support\Facades\Http;

class PagSeguroController extends Controller
{
    public function realizarPagamento(Request $request)
    {
        // Configurar as credenciais do PagSeguro
        $emailPagSeguro = env('PAGSEGURO_EMAIL');
        $tokenPagSeguro = env('PAGSEGURO_TOKEN');

        $email = $request->input('email');
        session()->put('email', $email);

        // Verifique se o email existe no banco de dados
        $usuario = User::where('email', $email)->first();
        if (!$usuario) {
            return view('noemail');
        }

        // Crie um item de pagamento
        $item = [
            'id' => '1',
            'description' => 'Assinatura Ultraflix',
            'amount' => 10.0, // Defina o preço aqui
            'quantity' => 1,
        ];

        // Crie uma URL de notificação (Webhook)
        $notificationUrl = route('pagamentoNotificacao');

        // Configurar os parâmetros do pagamento
        $params = [
            'email' => $emailPagSeguro,
            'token' => $tokenPagSeguro,
            'currency' => 'BRL',
            'reference' => $email,
            'redirectURL' => route('pagamentoSucesso'),
            'notificationURL' => $notificationUrl,
            'items' => [$item],
        ];

        // Realizar o pagamento e obter a URL de pagamento
        $response = Http::post('https://ws.sandbox.pagseguro.uol.com.br/v2/checkout', $params);
        $xml = simplexml_load_string($response->body());
        $paymentUrl = 'https://sandbox.pagseguro.uol.com.br/v2/checkout/payment.html?code=' . $xml->code;

        // Redirecione o usuário para a página de pagamento do PagSeguro
        return redirect($paymentUrl);
    }

    public function pagamentoSucesso(Request $request)
    {
        // Lógica para processar o pagamento bem-sucedido no retorno do PagSeguro
        // ...

        return view('sucesso');
    }

    public function showPagamentoForm()
{
    return view('pagamento-p');
}

    public function handlePagSeguroWebhook(Request $request)
    {
        // Lógica para lidar com notificações do PagSeguro (Webhook)
        // ...

        return response()->json(['status' => 'ok']);
    }

    // Outros métodos e lógica necessários
}
