<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MovieVideo;
use App\Movie;
use BackblazeB2\Client;
use BackblazeB2\Bucket;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Genre;
use App\Cast;
use App\MovieGenre;
use App\MovieCast;





class MovieVideoController extends Controller
{
    public function store()
    {
        $accountId = '00517533f925c8f0000000002';
        $applicationKey = 'K005b3uS0ailz8gkjU6itmzBHm9hndc';
        $bucketId = '7107f533f3af690285ac081f';
        $bucketName = 'utxgmpx';

        // Criar um cliente Backblaze B2
        $client = new Client($accountId, $applicationKey);

        // Listar todos os arquivos dentro do bucket, incluindo subpastas
        $fileList = $client->listFiles([
            'BucketId' => $bucketId
        ]);

        $filteredFiles = array_filter($fileList, function($file) {
            return strpos($file->getName(), 'f/') === 0;
        });
        
        Movie::query()->update(['active' => 1]);

        $unlinkedFiles = [];

        foreach ($filteredFiles as $file) {
            $fileName = $file->getName();
            
            // Extrair o tmdb_id do nome do arquivo
            preg_match('/_(\d+)\.mp4$/', $fileName, $matches);
            $tmdb_id_in_file = $matches[1] ?? null;
        
            if ($tmdb_id_in_file) {
                // Obter o filme usando o tmdb_id
                $movie = Movie::where('tmdb_id', $tmdb_id_in_file)->first();
        
                if ($movie) {
                    // dump("Filme encontrado: " . $movie->id);
        
                    // Construir a URL do arquivo
                    $bucket_url = 'https://v.baixarfree.com/file/'. $bucketName . '/' . $fileName;

                    // dump($fileName);
        
                    // Procurar se o vídeo já existe na tabela
                    $existingVideo = MovieVideo::where('movie_id', $movie->id)->where('server', 'Servidor 1')->first();
        
                    if ($existingVideo) {
                        // Atualizar o link existente
                        $existingVideo->update(['link' => $bucket_url]);
                    } else {
                        // Criar novo registro
                        MovieVideo::create([
                            'movie_id' => $movie->id,
                            'link' => $bucket_url,
                            'server' => 'Servidor 1' // Adicionando um servidor, como no seu exemplo
                        ]);
                    }
                } else {
                    $unlinkedFiles[] = $file->getName(); // Adiciona o nome do arquivo à lista
                    // dump($unlinkedFiles);
                }
            }
        }

        $movieIdsWithLinks = MovieVideo::distinct()->pluck('movie_id')->toArray();

        // Marcar como inativos todos os filmes que não têm um link na tabela MovieVideo
        Movie::whereNotIn('id', $movieIdsWithLinks)->update(['active' => 0]);

        $inactiveMovies = Movie::where('active', 0)->get();

        // dump($inactiveMovies->first());


        // Criar um arquivo .txt com os IDs desses filmes
        $txtContent = "";
        foreach ($inactiveMovies as $movie) {
            $txtContent .= "ID: " . $movie->id . " | Nome: " . $movie->title . " | TMDB_ID: " . $movie->tmdb_id . PHP_EOL;
        }

        // dump($txtContent);

        // Gerar o arquivo .txt
        $filePath = storage_path('inactive_movies.txt');
        file_put_contents($filePath, $txtContent);

        // Fazer o upload para o Backblaze
        $fileContent = file_get_contents($filePath);
        $fileNameOnBackblaze = 'filmes-semlink-inativos.txt';

        $client->upload([
            'BucketId' => $bucketId,
            'FileName' => $fileNameOnBackblaze,
            'Body' => $fileContent,
        ]);

        // Excluir o arquivo .txt local, se desejado
        unlink($filePath);


        $txtUnlinkedFilesContent = implode(PHP_EOL, $unlinkedFiles);
        dump($txtUnlinkedFilesContent);

        // Gerar o arquivo .txt
        $filePathUnlinkedFiles = storage_path('unlinked_files.txt');
        file_put_contents($filePathUnlinkedFiles, $txtUnlinkedFilesContent);

        // Fazer o upload para o Backblaze
        $fileUnlinkedContent = file_get_contents($filePathUnlinkedFiles);
        $fileNameOnBackblazeUnlinked = 'arquivos-nao-associados.txt';

        $client->upload([
            'BucketId' => $bucketId,
            'FileName' => $fileNameOnBackblazeUnlinked,
            'Body' => $fileUnlinkedContent,
        ]);

        // Excluir o arquivo .txt local, se desejado
        unlink($filePathUnlinkedFiles);
        
        

        // dump($movie);
    }

    public function importMovies()
{
    $ids_txt = file_get_contents('https://f005.backblazeb2.com/file/utxgmpx/ids_dos_filmes.txt');

    if ($ids_txt === false) {
        \Log::error('Erro ao ler o arquivo.');
        return;
    }

    if (trim($ids_txt) === '') {
        \Log::error('O arquivo está vazio.');
        return;
    }

    $movie_ids = explode(',', $ids_txt);
    $chunk_size = 100;
    $movie_chunks = array_chunk($movie_ids, $chunk_size);

    $allGenres = Genre::all()->keyBy('name');
    $allCasts = Cast::all()->keyBy('name');

    foreach ($movie_chunks as $chunk) {
        foreach ($chunk as $id) {
            try {
                DB::beginTransaction();
                $this->processMovie($id, $allGenres, $allCasts);
                DB::commit();
            } catch (\Exception $e) {
                DB::rollback();
                \Log::error("Erro ao processar o filme ID: {$id}. Mensagem: " . $e->getMessage());
            }
        }

        sleep(1); 
    }
}

private function processMovie($id, $allGenres, $allCasts)
{
    $api_key = env('TMDB_API_KEY');
    $base_image_url = "http://image.tmdb.org/t/p/w500";
    $base_image_url_tv = "http://image.tmdb.org/t/p/original";

    $response = Http::get("https://api.themoviedb.org/3/movie/$id", [
        'api_key' => $api_key,
        'language' => 'pt-BR',
        'append_to_response' => 'videos,credits'
    ]);

    if (!$response->successful()) {
        throw new \Exception("API request failed for movie ID: {$id}");
    }

    $data = $response->json();

    $movie = Movie::firstOrNew(['tmdb_id' => $data['id']]);

    if (!$movie->exists) {
        $movie->fill([
            $movie->tmdb_id = $data['id'],
            $movie->title = $data['title'],
            $movie->overview = $data['overview'],
            $movie->poster_path = $base_image_url . $data['poster_path'],
            $movie->backdrop_path = $base_image_url . $data['backdrop_path'],
            $movie->backdrop_path_tv = $base_image_url_tv . $data['backdrop_path'],
            $movie->preview_path = $data['videos']['results'][0]['key'] ?? null,
            $movie->vote_average = $data['vote_average'],
            $movie->vote_count = $data['vote_count'],
            $movie->popularity = $data['popularity'],
            $movie->runtime = $data['runtime'],
            $movie->release_date = $data['release_date'],
            $movie->imdb_external_id = $data['imdb_id'],
            $movie->original_name = $data['original_title'],
        ])->save();

        $this->associateGenres($movie, $data['genres'], $allGenres);
    $this->associateCast($movie, $data['credits']['cast'], $allCasts);
    }
}

private function associateGenres($movie, $genres, $allGenres)
{
    foreach ($genres as $genreData) {
        $genre = $allGenres[$genreData['name']] ?? null;
        if ($genre) {
            MovieGenre::firstOrCreate([
                'movie_id' => $movie->id,
                'genre_id' => $genre->id
            ]);
        }
    }
}

private function associateCast($movie, $castDataList, $allCasts)
{
    foreach ($castDataList as $castData) {
        $actor = $allCasts[$castData['name']] ?? null;
        if ($actor) {
            MovieCast::firstOrCreate([
                'movie_id' => $movie->id,
                'cast_id' => $actor->id
            ]);
        }
    }
}

public function filemoon(Request $request)
{
    $fileCode = '2dc7gy9u7cw4';
    $apiKey = '25759rykfdxwm3uk7d780'; // Substitua com sua chave API, se necessário

    // Fazendo a solicitação GET para a API externa
    $response = Http::get("https://vidhideapi.com/api/file/direct_link", [
        'key' => $apiKey,
        'file_code' => $fileCode

    ]);

    // Retorna a resposta JSON recebida da API externa
    return response()->json($response->json(),200);
}


public function getDirectLink(Request $request)
{
    $fileCode = 'itmzf9zabhuv';
    $apiKey = '21485czswc4r0eu1mwkdk'; // Substitua com sua chave API, se necessário

    // Fazendo a solicitação GET para a API externa
    $response = Http::get("https://streamvid.net/api/file/list", [
        'key' => $apiKey,
        'file_code' => $fileCode,
        'hls' => 1
    ]);

    // Retorna a resposta JSON recebida da API externa
    return response()->json($response->json());
}

    public function listLink(Request $request)
    {
        $fileCode = 'n3r72jrpfhpd';
        $apiKey = '9927ehu403ttu4hs5tqp'; // Substitua com sua chave API, se necessário

        // Fazendo a solicitação GET para a API externa
        $response = Http::get("https://api.streamwish.com/api/file/list", [
            'key' => $apiKey,
        ]);

        // Retorna a resposta JSON recebida da API externa
        return response()->json($response->json());
    }

}
