<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Preference\PreferenceClient;
use MercadoPago\Exceptions\MPApiException;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;


class MercadoPagoController extends Controller
{
    

    
    protected function authenticate()
    {
        $mpAccessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        MercadoPagoConfig::setAccessToken($mpAccessToken);
    
    }

    protected function realizarPagamento($items, $payer, $email, $additionalInfo = []): array
{
    $paymentMethods = [
        "excluded_payment_methods" => [],
        "installments" => 12,
        "default_installments" => 1
    ];

    $backUrls = [
        'success' => 'https://payutx.com/pagamento/sucesso',
        'failure' => 'https://payutx.com/pagamento/falha',
        'pending' => 'https://payutx.com/pagamento/pendente',
    ];

    // Preparando o array metadata para incluir informações adicionais
    $metadata = [
        'cliente' => [$payer],
        'items' => $items,
    ];

    // Se existem informações adicionais, mesclamos ao array metadata
    if (!empty($additionalInfo)) {
        $metadata = array_merge($metadata, $additionalInfo);
    }

    $request = [
        "items" => $items,
        "payer" => $payer,
        "payment_methods" => $paymentMethods,
        "back_urls" => $backUrls,
        "statement_descriptor" => "ULTRAFLIX",
        "external_reference" => $email,
        "expires" => false,
        "notification_url" => 'https://payutx.com/webhook/mercadopago',
        "auto_return" => 'approved',
        "metadata" => $metadata
    ];

    return $request;
}


    public function createPaymentPreference(Request $request)
    {
        $this->authenticate();
    
        $email = $request->input('email');
        $nome = $request->input('name');
    
        // Verifica se o email já existe no banco de dados
        $userExists = User::where('email', $email)->exists();
    
        if (!$userExists) {
            return response()->json(['error' => 'Email não encontrado.'], 400);
        }
    
        $selectedPlanos = $request->input('selectedPlanos');
    
        $planos = [
            'plano1' => ['preco' => 5.90, 'dias' => 15],
            'plano2' => ['preco' => 9.90, 'dias' => 30],
            'plano5' => ['preco' => 15.90, 'dias' => 60],
            'plano3' => ['preco' => 24.90, 'dias' => 90],
            'plano6' => ['preco' => 14.90, 'dias' => 30],
        ];
    
        $items = [];
        $additional_info = [];
    
        foreach ($selectedPlanos as $plano) {
            if (!array_key_exists($plano, $planos)) {
                return response()->json(['error' => 'Plano selecionado é inválido.'], 400);
            }
    
            $items[] = [
                "title" => "Assinatura - " . $planos[$plano]['dias'] . " Dias",
                "quantity" => 1,
                "currency_id" => "BRL",
                "unit_price" => $planos[$plano]['preco'],
                "description" => $planos[$plano]['dias']
            ];
    
            if ($plano === 'plano6') {
                $additional_info = ['tv_access' => 1, 'expired_in_tv' => 30];
            }
        }
    
        $payer = [
            "email" => $email,
            "first_name" => $nome,
        ];
    
        $request = $this->realizarPagamento($items, $payer, $email, $additional_info);
    
        $client = new PreferenceClient();
    
        try {
            $preference = $client->create($request);
            return response()->json(['url' => $preference->init_point]);
        } catch (MPApiException $error) {
            return response()->json(['error' => $error->getMessage()], 500);
        }
    }



public function pagamentoSucesso(Request $request)
{
    $url = $request->fullUrl();
    $parsedUrl = parse_url($url);
    $queryParams = [];
    parse_str($parsedUrl['query'], $queryParams);

    if (isset($queryParams['id'])) {
        $collectionId = $queryParams['id'];
        $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";

        $response = Http::get($url);

        if ($response->successful()) {
            $payment = $response->json();

            if ($payment['status'] == 'approved') {
                $tvAccess = $payment['metadata']['tv_access'] ?? null;
                $expiredInTv = $payment['metadata']['expired_in_tv'] ?? null;

                $email = $payment['metadata']['cliente'][0]['email'] ?? null;
                $nome = $payment['metadata']['cliente'][0]['first_name'] ?? null;
                $dias = $payment['metadata']['items'][0]['description'] ?? null;

                if (!$email || !$nome) {
                    return response()->json(['error' => 'Informações essenciais do cliente não encontradas na metadata'], 422);
                }

                $usuario = DB::table('users')->where('email', '=', $email)->first();

                if ($tvAccess == 1 && $expiredInTv && $usuario) {
                    DB::table('users')
                        ->where('email', '=', $email)
                        ->update([
                            'tv_access' => 1,
                            'expired_in_tv' => Carbon::now()->addDays($expiredInTv)
                        ]);
                }

                if ($usuario) {
                    // Atualiza o usuário existente com informações adicionais
                    DB::table('users')
                        ->where('email', '=', $email)
                        ->update([
                            "premuim" => true,
                            "expired_in" => Carbon::now()->addDays($dias)
                        ]);
                } else {
                    // Cria um novo usuário com informações recebidas do pagamento
                    $randomPassword = Str::random(6);
                    $novoUsuario = [
                        'email' => $email,
                        'name' => $nome,
                        'password' => Hash::make($randomPassword),
                        'premuim' => true,
                        'expired_in' => Carbon::now()->addDays($dias),
                    ];

                    DB::table('users')->insert($novoUsuario);
                }
                return view('sucesso');
            } else {
                // Renderizar a view pendente e iniciar a atualização a cada 3 segundos
                echo "<script>
                        setTimeout(function(){
                            location.reload();
                        }, 3000);
                      </script>";
                return view('pendente');
            }
        }
    }
}

    

public function pagamentoPendente(Request $request)
{
    $url = $request->fullUrl();
    $parsedUrl = parse_url($url);
    $queryParams = [];
    parse_str($parsedUrl['query'], $queryParams);

    if (isset($queryParams['id'])) {
        $collectionId = $queryParams['id'];
        $accessToken = env('MERCADOPAGO_ACCESS_TOKEN');
        $url = "https://api.mercadopago.com/v1/payments/{$collectionId}?access_token={$accessToken}";

        $response = Http::get($url);

        if ($response->successful()) {
            $payment = $response->json();
            

            if ($payment['status'] == 'approved') {
                $tvAccess = $payment['metadata']['tv_access'] ?? null;
                $expiredInTv = $payment['metadata']['expired_in_tv'] ?? null;

                $email = $payment['metadata']['cliente'][0]['email'] ?? null;
                $nome = $payment['metadata']['cliente'][0]['first_name'] ?? null;
                $dias = $payment['metadata']['items'][0]['description'] ?? null;

                if (!$email || !$nome) {
                    return response()->json(['error' => 'Informações essenciais do cliente não encontradas na metadata'], 422);
                }

                $usuario = DB::table('users')->where('email', '=', $email)->first();

                if ($tvAccess == 1 && $expiredInTv && $usuario) {
                    DB::table('users')
                        ->where('email', '=', $email)
                        ->update([
                            'tv_access' => 1,
                            'expired_in_tv' => Carbon::now()->addDays($expiredInTv)
                        ]);
                }

                if ($usuario) {
                    // Atualiza o usuário existente com informações adicionais
                    DB::table('users')
                        ->where('email', '=', $email)
                        ->update([
                            "premuim" => true,
                            "expired_in" => Carbon::now()->addDays($dias)
                        ]);
                } else {
                    // Cria um novo usuário com informações recebidas do pagamento
                    $randomPassword = Str::random(6);
                    $novoUsuario = [
                        'email' => $email,
                        'name' => $nome,
                        'password' => Hash::make($randomPassword),
                        'premuim' => true,
                        'expired_in' => Carbon::now()->addDays($dias),
                    ];

                    DB::table('users')->insert($novoUsuario);
                }
                return view('sucesso');
            } else {
                // Renderizar a view pendente e iniciar a atualização a cada 3 segundos
                echo "<script>
                        setTimeout(function(){
                            location.reload();
                        }, 3000);
                      </script>";
                return view('pendente');
            }
        }
    }
}
 
    
    
     public function pagamentoFalha()
    {
        return view('falha');
    }

    public function showChoosePlan() {
        return view('layouts.choose_plan');
    }

    public function assinar() {
        return view('assinar');
    }

    public function testeassinar() {
        return view('pagamento-p');
    }
}

