<?php

namespace App\Http\Controllers;

use App\Http\Requests\LivetvRequest;
use App\Http\Requests\StoreImageRequest;
use App\Jobs\SendNotification;
use App\Livetv;
use App\LivetvGenre;
use App\LivetvVideo;
use App\Category;
use App\Setting;
use Illuminate\Http\Response;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use App\VideoAccessToken;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Support\Facades\Session;

class LivetvController extends Controller
{


    public function show($id)
{
    $streaming = Livetv::with(['videos'])->where('id', $id)->first();

    if (!$streaming) {
        return response()->json(['message' => 'Livetv not found'], 404);
    }

    $generosDoFilme = $streaming->genres->pluck('name')->toArray();

    $filmesRelacionados = Livetv::query()
            ->whereHas('genres.genre', function ($query) use ($generosDoFilme) {
                $query->whereIn('name', $generosDoFilme);
            })
            ->where('id', '!=', $id)
            ->limit(32)
            ->where('active', '=', 1)
            ->orderByRaw('RAND()')
            ->get();

    $streaming->increment('views', 1);

    $payload = [
        // Outros campos do payload
        'sessionId' => Session::getId(), // Exemplo usando ID de sessão do Laravel
    ];

    if (Auth::check()) {
        $user = Auth::user();
        $key = 'iCUjW0hsKrkJXWiUMzASowBPafh65dBAhqYzEFcLcedIQRtZ3IvaBedZupvlZoeb';
        $payload = [
            'iss' => "your-issuer",
            'aud' => "your-audience",
            'iat' => time(),
            'exp' => time() + 3600,
            'sub' => $user->id,
        ];

        $jwt = JWT::encode($payload, $key, 'HS256');
        $token = $jwt;
    } else {
        $token = null;
    }

    return view('canal', [
        'livetv' => $streaming,
        'filmesRelacionados' => $filmesRelacionados,
        'token' => $token,
    ]);
}

public function generateVideoUrl($id)
{
    $channel = Livetv::with('videos')->find($id);
    if (!$channel || $channel->videos->isEmpty()) {
        return response()->json(['message' => 'Canal de TV não encontrado ou sem vídeos associados'], 404);
    }

    $video = $channel->videos->first();
    $videoUrl = $video->link;

    $token = null;
    if (auth()->check()) {
        $user = auth()->user();
        $key = 'iCUjW0hsKrkJXWiUMzASowBPafh65dBAhqYzEFcLcedIQRtZ3IvaBedZupvlZoeb';
        $payload = [
            'iss' => 'your-issuer',
            'aud' => 'your-audience',
            'iat' => time(),
            'exp' => time() + 3600, // 1 hour from now
            'sub' => $user->id, // Subject, typically user ID
        ];

        $token = JWT::encode($payload, $key, 'HS256');
    }

    if ($token) {
        // Verifica se a URL já possui query params
        $separator = parse_url($videoUrl, PHP_URL_QUERY) ? '&' : '?';
        $videoUrl .= $separator . "token=$token";
    }

    return response()->json(['videoUrl' => $videoUrl]);
}

public function getChannelInfo($id)
{
    $channel = Livetv::with(['videos', 'genres.genre'])->find($id);

    if (!$channel) {
        return response()->json(['message' => 'Canal não encontrado'], 404);
    }

    // Incrementa visualizações
    $channel->increment('views', 1);

    return response()->json($channel);
}

public function showPlayer($videoId)
{
    $user = Auth::user();
    $video = LivetvVideo::findOrFail($videoId);
    $token = Str::random(60); // Gera um token único

    // Armazena o token associado ao vídeo e ao usuário
    VideoAccessToken::create([
        'livetv_video_id' => $video->id,
        'user_id' => $user->id,
        'token' => hash('sha256', $token), // Segurança adicional
        'expires_at' => now()->addMinutes(60), // Expira em 1 hora
    ]);

    // A URL do stream contém o token gerado
    $streamUrl = "{$video->link}?token={$token}";

    return view('canal', compact('streamUrl')); // Passa a URL para a view
}

public function getM3U8Url()
    {
        $client = new Client();
        $url = 'https://filemoon.sx/e/pdug3pyua9cn'; // Substitua pelo URL do embed real

        try {
            $response = $client->request('GET', $url, [
                'headers' => [
                    'Referer' => 'https://filemoon.sx/',
                    'Host' => 'be7713.rcr82.waw05.cdn112.com',
                    'Accept' => 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
                    'Origin' => 'https://filemoon.sx',
                    'Cookie' => 'file_id=21000225; aff=22317',
                    'User-Agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3'
                ]
            ]);
            $html = $response->getBody()->getContents();

            $crawler = new Crawler($html);
            $m3u8Url = $crawler->filter('source[type="application/x-mpegURL"]')->attr('src');

            return response()->json(['link' => $m3u8Url]);
        } catch (\Exception $e) {
            // Tratamento de exceções
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }



    public function addtofav($movie,Request $request)
    {

    $movie = Livetv::where('id', '=', $movie)->first()->addFavorite($request->user()->id);

            return response()->json("Success", 200);

    }


    public function removefromfav($id,Request $request)
    {

        $movie = Livetv::where('id', '=', $id)->first()->removeFavorite($request->user()->id);


        return response()->json("Added", 200);


    }


    public function isMovieFavorite($id,Request $request)
    {

        $movie = Livetv::where('id', '=', $id)->first();

        if($movie->isFavorited($request->user()->id)) {

            $data = ['status' => 200, 'status' => 1,];

        }else {

            $data = ['status' => 400, 'status' => 0,];
        }

        return response()->json($data, 200);
    }



    public function relateds(Livetv $movie)
    {


        $genre = $movie->genres[0]->category_id;
        $movies = LivetvGenre::where('category_id', $genre)->where('livetv_id', '!=', $movie->id)
            ->limit(6)
            ->get();
        $movies->load('livetv')->where('active', '=', 1);
        $relateds = [];
        foreach ($movies as $item) {
            array_push($relateds, $item['livetv']);
        }

        return response()->json(['relateds' => $relateds], 200);
    }





    public function latest()
    {

        $streaming = Livetv::orderByDesc('created_at')->where('active', '=', 1)
            ->limit(10)
            ->get();

        return response()
            ->json(['livetv' => $streaming], 200);
    }






    public function featured()

    {

     $movies = Livetv::where('featured', 1)->where('active', '=', 1)
            ->orderByDesc('created_at')
            ->get();
        return response()
            ->json(['featured_streaming' => $movies], 200);

    }


    public function mostwatched()

    {

        $movies = Livetv::orderByDesc('views')->where('active', '=', 1)
            ->get();


        return response()
            ->json(['watched' => $movies], 200);

    }


    // returns all livetv for admin panel
    public function data()
    {

        return response()->json(Livetv::with(['videos'])->orderByDesc('created_at')
        ->paginate(6), 200);
    }

    // create a new livetv in the database
    public function store(LivetvRequest $request)
    {
        if (isset($request->livetv)) {

            $livetv = new Livetv();
            $livetv->fill($request->livetv);
            $livetv->save();



            if ($request->livetv['genres']) {
                foreach ($request->livetv['genres'] as $genre) {

                    $find = Category::find($genre['id']);
                    if ($find == null) {
                        $find = new Category();
                        $find->fill($genre);
                        $find->save();
                    }
                    $movieGenre = new LivetvGenre();
                    $movieGenre->category_id = $genre['id'];
                    $movieGenre->livetv_id = $livetv->id;
                    $movieGenre->save();
                }
            }


            $this->onStoreVideo($request,$livetv);




            $data = [
                'status' => 200,
                'message' => 'successfully created',
                'body' => $livetv
            ];
        } else {
            $data = [
                'status' => 400,
                'message' => 'could not be created',
            ];
        }

        if ($request->notification) {
            $this->dispatch(new SendNotification($livetv));
        }

        return response()->json($data, $data['status']);
    }





    public function onStoreVideo($request,$livetv) {

        if ($request->links) {
            foreach ($request->links as $link) {

                $movieVideo = new LivetvVideo();
                $movieVideo->fill($link);
                $movieVideo->livetv_id = $livetv->id;
                $movieVideo->save();
            }
        }

    }





    // update a livetv in the database
    public function update(LivetvRequest $request, Livetv $livetv)
    {
        if ($livetv != null) {

            $livetv->fill($request->livetv);
            $livetv->save();


            if ($request->livetv['genres']) {
                foreach ($request->livetv['genres'] as $genre) {
                    if (!isset($genre['category_id'])) {
                        $find = Category::find($genre['id'] ?? 0) ?? new Category();
                        $find->fill($genre);
                        $find->save();
                        $movieGenre = LivetvGenre::where('livetv_id', $livetv->id)
                            ->where('category_id', $genre['id'])->get();
                        if (count($movieGenre) < 1) {
                            $movieGenre = new LivetvGenre();
                            $movieGenre->category_id = $genre['id'];
                            $movieGenre->livetv_id = $livetv->id;
                            $movieGenre->save();
                        }
                    }
                }
            }


            $this->onUpdateVideo($request,$livetv);


            $data = [
                'status' => 200,
                'message' => 'successfully updated',
                'body' => $livetv
            ];
        } else {
            $data = [
                'status' => 400,
                'message' => 'could not be updated',
            ];
        }

        return response()->json($data, $data['status']);
    }



    public function onUpdateVideo($request,$livetv) {

        if ($request->links) {
            foreach ($request->links as $link) {
                if (!isset($link['id'])) {
                    $movieVideo = new LivetvVideo();
                    $movieVideo->livetv_id = $livetv->id;
                    $movieVideo->fill($link);
                    $movieVideo->save();
                }
            }
        }

    }


     // remove the genre of a movie from the database
     public function destroyGenre($genre)
     {
        if ($genre != null) {

            LivetvGenre::find($genre)->delete();

            $data = ['status' => 200, 'message' => 'successfully deleted',];
        } else {
            $data = ['status' => 400, 'message' => 'could not be deleted',];
        }

        return response()->json($data, 200);
     }

    // delete a livetv in the database
    public function destroy(Livetv $livetv)
    {
        if ($livetv != null) {
            $livetv->delete();
            $data = [
                'status' => 200,
                'message' => 'successfully deleted',
            ];
        } else {
            $data = [
                'status' => 400,
                'message' => 'could not be deleted',
            ];
        }

        return response()->json($data, $data['status']);
    }

    // save a new image in the livetv folder of the storage
    public function storeImg(StoreImageRequest $request)
    {
        if ($request->hasFile('image')) {
            $filename = Storage::disk('livetv')->put('', $request->image);
            $data = [
                'status' => 200,
                'image_path' => $request->root() . '/api/livetv/image/' . $filename,
                'message' => 'successfully uploaded'
            ];
        } else {
            $data = [
                'status' => 400,
            ];
        }

        return response()->json($data, $data['status']);
    }

    // return an image from the livetv folder of the storage
    public function getImg($filename)
    {

        $image = Storage::disk('livetv')->get($filename);

        $mime = Storage::disk('livetv')->mimeType($filename);

        return (new Response($image, 200))
            ->header('Content-Type', $mime);
    }



     // remove a video from a movie from the database
     public function videoDestroy($video)
     {
         if ($video != null) {

            LivetvVideo::find($video)->delete();

             $data = ['status' => 200, 'message' => 'successfully deleted',];
         } else {
             $data = ['status' => 400, 'message' => 'could not be deleted',];
         }

         return response()->json($data, 200);
     }



       // return all the videos of a stream
       public function videos($movie)
       {

        $streaming = Livetv::where('id', '=', $movie)->first();

        return response()->json($streaming->videos, 200);
       }

}
