<?php

namespace App\Http\Controllers;

use App\Movie;
use App\Serie;
use App\Episode;
use App\Anime;
use App\AnimeEpisode;
use App\Setting;

class LandingController extends Controller
{
    public function index()
    {
        $topMovies = Movie::orderBy('views', 'desc')->take(10)->get();
        $topSeries = Serie::orderBy('views', 'desc')->take(10)->get();

        $totalMovies = Movie::count();
        $totalSeries = Serie::count();
        $totalEpisodes = Episode::count();
        $totalAnimes = Anime::count(); 
        $totalAnimeEpisodes = AnimeEpisode::count();

        $settings = Setting::first();

        return view('landing', compact('settings','topMovies', 'topSeries', 'totalMovies', 'totalSeries', 'totalEpisodes', 'totalAnimes', 'totalAnimeEpisodes'));
    }

    public function planos()
    {
        $topMovies = Movie::orderBy('views', 'desc')->take(10)->get();
        $topSeries = Serie::orderBy('views', 'desc')->take(10)->get();

        $totalMovies = Movie::count();
        $totalSeries = Serie::count();
        $totalEpisodes = Episode::count();
        $totalAnimes = Anime::count(); 
        $totalAnimeEpisodes = AnimeEpisode::count();

        $settings = Setting::first();

        return view('planos', compact('settings','topMovies', 'topSeries', 'totalMovies', 'totalSeries', 'totalEpisodes', 'totalAnimes', 'totalAnimeEpisodes'));
    }
}