<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Firebase\JWT\ExpiredException;
use Firebase\JWT\SignatureInvalidException;
use Firebase\JWT\BeforeValidException;
use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class FlussonicAuthController extends Controller
{
    private $key = 'iCUjW0hsKrkJXWiUMzASowBPafh65dBAhqYzEFcLcedIQRtZ3IvaBedZupvlZoeb';

    public function authenticate(Request $request)
    {

        if ($request->isMethod('get')) {
            $token = $request->query('token', '');

            if (empty($token)) {
                return $this->sendResponse(400, "Token não fornecido");
            }

            try {
                $decoded = JWT::decode($token, new Key($this->key, 'HS256'));

                return $this->sendResponse(200, "Autenticação bem-sucedida");
            } catch (ExpiredException $ee) {
                return $this->sendResponse(403, "Token expirado");
            } catch (SignatureInvalidException $sie) {
                return $this->sendResponse(403, "Assinatura do token inválida");
            } catch (BeforeValidException $bve) {
                return $this->sendResponse(403, "Token ainda não é válido");
            } catch (Exception $e) {
                Log::error('Erro inesperado: ' . $e->getMessage());
                return $this->sendResponse(500, "Erro interno do servidor");
            }
        } else {
            return response("Método não permitido", 405);
        }
    }

    private function sendResponse($code, $message)
    {
        return response()->json(['message' => $message], $code);
    }
}
