<?php

namespace App\Http\Controllers;

use App\Services\sCloud\SCloudService;
use Illuminate\Http\Request;

class FileController extends Controller
{
    protected $sCloudService;

    public function __construct(SCloudService $sCloudService)
    {
        $this->sCloudService = $sCloudService;
    }

    public function listFiles(Request $request)
    {
        try {
            $files = $this->sCloudService->getFiles($request->input('path', '/'));
            return response()->json($files);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
