<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\QueryException;
use App\Movie;
use App\Serie;
use App\Anime;
use App\Profile;
use Illuminate\Support\Facades\DB;
use App\Setting;

class FavoritosController extends Controller
{
    public function index()
    {
        try {
            // Obter o perfil selecionado da sessão
            $profileId = session('selected_profile')->id;
            $profile = Profile::find($profileId);

            if (!$profile) {
                return redirect()->route('inicio')
                    ->with('error', 'Perfil não encontrado. Por favor, selecione um perfil.');
            }

            // Buscar filmes favoritos diretamente da tabela favorites
            $favoriteMovies = Movie::query()
                ->join('favorites', function($join) use ($profileId) {
                    $join->on('movies.id', '=', 'favorites.favoriteable_id')
                        ->where('favorites.profile_id', '=', $profileId)
                        ->where('favorites.favoriteable_type', '=', Movie::class);
                })
                ->select('movies.*')
                ->get();

            // Buscar séries favoritas (se houver)
            $favoriteSeries = Serie::query()
                ->join('favorites', function($join) use ($profileId) {
                    $join->on('series.id', '=', 'favorites.favoriteable_id')
                        ->where('favorites.profile_id', '=', $profileId)
                        ->where('favorites.favoriteable_type', '=', Serie::class);
                })
                ->select('series.*')
                ->get();

            // Buscar animes favoritos (se houver)
            $favoriteAnimes = Anime::query()
                ->join('favorites', function($join) use ($profileId) {
                    $join->on('animes.id', '=', 'favorites.favoriteable_id')
                        ->where('favorites.profile_id', '=', $profileId)
                        ->where('favorites.favoriteable_type', '=', Anime::class);
                })
                ->select('animes.*')
                ->get();

            // Carregar as configurações para o layout
            $settings = Setting::query()->first();

            return view('favoritos', [
                'favoriteMovies' => $favoriteMovies,
                'favoriteSeries' => $favoriteSeries,
                'favoriteAnimes' => $favoriteAnimes,
                'settings' => $settings
            ]);

        } catch (QueryException $e) {
            // Log do erro
            \Log::error('Erro ao carregar favoritos: ' . $e->getMessage());

            // Se o erro for relacionado à tabela inexistente
            if (strpos($e->getMessage(), "Table") !== false && strpos($e->getMessage(), "doesn't exist") !== false) {
                return view('favoritos', [
                    'favoriteMovies' => collect([]),
                    'favoriteSeries' => collect([]),
                    'favoriteAnimes' => collect([]),
                    'settings' => Setting::query()->first()
                ])->with('warning', 'O sistema de favoritos está sendo configurado. Por favor, tente novamente mais tarde.');
            }

            // Outros erros
            return redirect()->route('inicio')
                ->with('error', 'Ocorreu um erro ao carregar seus favoritos. Por favor, tente novamente.');
        }
    }
}

