<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ExportController extends Controller
{
    public function exportSql(Request $request)
    {
        // Log que download foi iniciado
        $ip = $request->ip();
        Log::info("Iniciando download do SQL para IP: {$ip}");

        $tables = ['animes', 'anime_casts', 'anime_episodes', 'anime_genres', 'anime_networks', 'anime_seasons', 'anime_videos', 'episodes', 'movies', 'movie_casts', 'movie_genres', 'movie_networks', 'movie_videos', 'seasons', 'series', 'serie_casts', 'serie_genres', 'serie_networks', 'serie_videos'];
        $date = date('d-m-Y');
        $randomString = uniqid();

        $fileName = "dados-filmes-series-animes-{$date}-{$randomString}.sql";
        $filePath = storage_path("app/public/{$fileName}");

        $fileHandle = fopen($filePath, 'w+');

        DB::beginTransaction();  // Inicia uma transação

        fwrite($fileHandle, "SET FOREIGN_KEY_CHECKS = 0;\n");
        fwrite($fileHandle, "SET TIME_ZONE = '+00:00';\n\n"); // Configura o fuso horário para UTC

        foreach ($tables as $table) {
            $autoIncrement = DB::select("SHOW TABLE STATUS LIKE '{$table}'")[0]->Auto_increment ?? 'AUTO_INCREMENT';

            fwrite($fileHandle, "DROP TABLE IF EXISTS `{$table}`;\n");
            $createTable = DB::select("SHOW CREATE TABLE {$table}")[0]->{'Create Table'};
            fwrite($fileHandle, "{$createTable};\n");
            fwrite($fileHandle, "ALTER TABLE `{$table}` AUTO_INCREMENT = {$autoIncrement};\n");

            // Seleciona todos os dados da tabela e prepara para um insert em massa
            $rows = DB::table($table)->get();
            $chunks = array_chunk($rows->toArray(), 1000);  // Chunking the rows to avoid memory overflow
            foreach ($chunks as $chunk) {
                $values = array_map(function ($row) use ($table) {
                    $row = (array) $row;
                    $valueList = array_map(function ($value) {
                        return is_null($value) ? 'NULL' : (is_string($value) ? "'" . addslashes($value) . "'" : $value);
                    }, $row);
                    return '(' . implode(', ', $valueList) . ')';
                }, $chunk);
                if (count($values) > 0) {
                    $columns = '`' . implode('`, `', array_keys((array) $chunk[0])) . '`';
                    $insertQuery = "INSERT INTO `{$table}` ({$columns}) VALUES \n" . implode(",\n", $values) . ";\n";
                    fwrite($fileHandle, $insertQuery);
                }
            }

            // Captura de triggers para a tabela
            $triggers = DB::select("SHOW TRIGGERS LIKE '{$table}'");
            foreach ($triggers as $trigger) {
                fwrite($fileHandle, "CREATE TRIGGER `{$trigger->Trigger}` {$trigger->Timing} {$trigger->Event} ON `{$table}` FOR EACH ROW {$trigger->Statement};\n");
            }

            fwrite($fileHandle, "\n");
        }

        fwrite($fileHandle, "SET FOREIGN_KEY_CHECKS = 1;\n");
        DB::commit();  // Commit da transação

        fclose($fileHandle);

        // Log que download foi concluído
        Log::info("Download SQL concluído com sucesso para IP: {$ip}");

        return response()->download($filePath, $fileName, ['Content-Type' => 'application/sql'])->deleteFileAfterSend(true);
    }
}
