<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;

class EmailVerificationController extends Controller
{
    public function showForm()
    {
        return view('verificar-email');
    }

    public function verifyEmail(Request $request)
    {
        $email = $request->input('email');

        // Verifique se o e-mail existe no banco de dados
        $user = User::where('email', $email)->first();

        if ($user) {
            // E-mail encontrado, permita que o usuário prossiga
            // Redirecione para a página desejada
            return redirect()->route('pagina-desejada');
        } else {
            // E-mail não encontrado, exiba uma mensagem de erro
            return back()->with('error', 'E-mail não encontrado');
        }
    }
}
