<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Serie;

class DebugController extends Controller
{
    public function checkSerieData($id)
    {
        $serie = Serie::with([
            'casters.cast' => function ($query) {
                $query->select('id', 'name', 'original_name', 'profile_path');
            },
            'seasons.episodes.videos'
        ])->find($id);

        if (!$serie) {
            return response()->json(['error' => 'Série não encontrada'], 404);
        }

        // Verificar os dados carregados
        $debug = [
            'serie_name' => $serie->name,
            'has_casters' => $serie->casters->count() > 0,
            'casters_count' => $serie->casters->count(),
            'has_seasons' => $serie->seasons->count() > 0,
            'seasons_count' => $serie->seasons->count(),
            'seasons_data' => $serie->seasons->map(function ($season) {
                return [
                    'season_number' => $season->season_number,
                    'episodes_count' => $season->episodes->count(),
                    'has_episodes_with_videos' => $season->episodes->filter(function ($episode) {
                        return $episode->videos->count() > 0;
                    })->count() > 0
                ];
            }),
        ];

        return response()->json($debug);
    }
}
