<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function showLoginForm()
    {
        return view('auth.login_web');
    }

    public function login(Request $request)
    {
        $credentials = $request->validate([
            'username' => 'required',
            'password' => 'required',
        ]);

        if (Auth::attempt($credentials)) {
            return redirect()->route('inicio');
        } else {
            return back()->withErrors(['username' => 'Credenciais inválidas']);
        }
    }

    public function logout()
    {
        Auth::logout();
        return redirect('/');
    }
}
