<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Serie;
use App\Episode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EpisodeVideoController extends Controller
{
    public function getEpisodeVideo($serieId, $episodeId)
    {
        try {
            // Verificar se o episódio existe e pertence à série
            $episode = Episode::where('id', $episodeId)
                ->whereHas('season', function ($query) use ($serieId) {
                    $query->where('serie_id', $serieId);
                })
                ->first();

            if (!$episode) {
                return response()->json(['error' => 'Episódio não encontrado'], 404);
            }

            // Buscar o primeiro vídeo disponível para o episódio
            $video = DB::table('serie_videos')
                ->where('episode_id', $episodeId)
                ->orderBy('created_at', 'desc')
                ->first();

            if (!$video) {
                return response()->json(['error' => 'Nenhum vídeo disponível para este episódio'], 404);
            }

            // Retornar a URL do vídeo
            return response()->json([
                'videoUrl' => $video->link,
                'videoServer' => $video->server,
                'videoEmbed' => $video->embed,
                'videoHls' => $video->hls
            ]);

        } catch (\Exception $e) {
            return response()->json(['error' => 'Erro ao processar a solicitação', 'message' => $e->getMessage()], 500);
        }
    }
}
