<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\Client;
use Illuminate\Support\Carbon;
use App\User;
use App\Plan;
use App\Movie;
use App\Profile;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use Google\Client as GoogleClient;
use App\UserSession;

class LoginController extends Controller
{


    const MESSAGE = "successfully updated";

    use IssueTokenTrait;

    private $client;

    public function __construct()
    {
       $this->client = Client::find(2);
        $this->middleware('doNotCacheResponse');

    }

    public function loginFacebook(Request $request)
    {
        $provider = "facebook"; // or $request->input('provider_name') for multiple providers
    
        // get the provider's user. (In the provider server)
        $providerUser = Socialite::driver($provider)->userFromToken($request->token);
        // check if access token exists etc..
        // search for a user in our server with the specified provider id and provider name
        $user = User::where('provider_name', $provider)->where('provider_id', $providerUser->id)->first();
        // if there is no record with these data, create a new user
        if($user == null){
            $user = User::create([
                'name' => $providerUser->name,
                'email' => $providerUser->email,
                'avatar' => $providerUser->avatar,
                'premuim' => false,
                'manual_premuim' => false,
                'provider_name' => $provider,
                'provider_id' => $providerUser->id
            ]);
        

            $tokenResult = $user->createToken('facebook');
            return \response()->json([
                'token_type'    =>  'Bearer',
                'expires_in'    =>  $tokenResult->token->expires_at->diffInSeconds(Carbon::now()),
                'access_token'  =>  $tokenResult->accessToken,
                'refresh_token'  =>  $tokenResult->refreshToken,
                'type'          =>  'facebook'
            ]);
        }
        $tokenResult = $user->createToken('facebook');
        return \response()->json([
            'token_type'    =>  'Bearer',
            'expires_in'    =>  $tokenResult->token->expires_at->diffInSeconds(Carbon::now()),
            'access_token'  =>  $tokenResult->accessToken,
            'type'          =>  'facebook'
        ]);

    }




    public function loginGoogle(Request $request)
{
    $googleClient = new GoogleClient(['client_id' => env('GOOGLE_CLIENT_ID')]);
    $idToken = $request->input('token');

    if (!$idToken) {
        return response()->json(['error' => 'Token ID is missing'], 400);
    }

    $payload = $googleClient->verifyIdToken($idToken);

    if ($payload) {
        $user = User::where('provider_name', 'google')
                    ->where('provider_id', $payload['sub'])
                    ->first();

        if (!$user) {
            $user = User::where('email', $payload['email'])->first();
        }

        if (!$user) {
            $user = User::create([
                'name' => $payload['name'],
                'email' => $payload['email'],
                'avatar' => $payload['picture'],
                'provider_name' => 'google',
                'premuim' => false,
                'manual_premuim' => false,
                'provider_id' => $payload['sub']
            ]);
        } else {
            $user->update([
                'name' => $payload['name'],
                'avatar' => $payload['picture'],
                'provider_name' => 'google',
                'provider_id' => $payload['sub']
            ]);
        }

        // Gerar token de dispositivo
        $deviceToken = \Str::uuid();

        // Limitar o número de sessões ativas
        $activeSessions = UserSession::where('user_id', $user->id)->count();
        if ($activeSessions >= UserSession::MAX_ACTIVE_SESSIONS) {
            // Obter a sessão mais antiga e excluí-la
            $oldestSession = UserSession::where('user_id', $user->id)
                                        ->orderBy('created_at', 'asc')
                                        ->first();
            if ($oldestSession) {
                $oldestSession->delete();
            }
        }

        // Armazenar nova sessão
        UserSession::create([
            'user_id' => $user->id,
            'device_token' => $deviceToken,
        ]);

        // Adicionar o token de dispositivo à sessão
        $request->session()->put('device_token', $deviceToken);

        // Autenticar o usuário
        Auth::login($user);

        return response()->json([
            'success' => true,
            'redirect' => route('choose-profile'),
            'device_token' => $deviceToken
        ]);
    } else {
        return response()->json(['error' => 'Invalid ID Token'], 401);
    }
}



public function login(Request $request)
{
    $this->validate($request, [
        'username' => 'required',
        'password' => 'required'
    ]);

    $user = User::where('email', $request->username)->first();

    if ($user && Hash::check($request->password, $user->password)) {
        Auth::login($user);
        $deviceToken = \Str::uuid();

        // Limitar o número de sessões ativas
        $activeSessions = UserSession::where('user_id', $user->id)->count();
        if ($activeSessions >= UserSession::MAX_ACTIVE_SESSIONS) {
            // Obter a sessão mais antiga e excluí-la
            $oldestSession = UserSession::where('user_id', $user->id)
                                        ->orderBy('created_at', 'asc')
                                        ->first();
            if ($oldestSession) {
                $oldestSession->delete();
            }
        }

        // Armazenar nova sessão
        UserSession::create([
            'user_id' => $user->id,
            'device_token' => $deviceToken,
        ]);

        // Adicionar o token de dispositivo à sessão
        session(['device_token' => $deviceToken]);

        return $this->issueToken($request, 'password');
    
    }
}


    public function showLoginForm() {
        return view('auth.login_web');
    }



    public function createNewProfile(Request $request) {

        $user = Auth()->user();

        
        $movieVideo = new Profile();
        $movieVideo->name = $request->name;
        $movieVideo->user_id = $user->id;
        $movieVideo->image = $user->image;
        $movieVideo->fill($request->all());
        $movieVideo->save();

        
        $data = [
            'status' => 200,
            self::MESSAGE,
            'body' => $user
        ];

        return response()->json($data, $data['status']);

    }


    public function refresh(Request $request)
    {
        $this->validate($request, [
            'refresh_token' => 'required'
        ]);

        return $this->issueToken($request, 'refresh_token');


    }

    public function update(Request $request,Plan $plan)
    {

       
        $accessToken = Auth::user()->token();


        DB::table('users')
            ->where('id', $accessToken->user_id)
            ->update(

                array( 
                    "premuim" => true,
                    "pack_name" => request('pack_name'),
                    "expired_in" => Carbon::now()->addDays(request('pack_duration'))
    
   )

            );
            


        return response()->json([], 204);

    }





    public function updatePaypal(Request $request,Plan $plan)
    {


        $this->validate($request, [
            'transaction_id' => 'required',
            'pack_id' => 'required',
            'pack_name' => 'required',
            "type" => 'required',
            "pack_duration" => 'required']);
        
       
        $accessToken = Auth::user()->token();


        DB::table('users')
            ->where('id', $accessToken->user_id)
            ->update(

                array( 
                    "premuim" => true,
                    "transaction_id" => request('transaction_id'),
                    "pack_id" => request('pack_id'),
                    "pack_name" => request('pack_name'),
                    "type" => 'paypal',
                    "expired_in" => Carbon::now()->addDays(request('pack_duration'))));
            
   return response()->noContent();

    }




    public function addPlanToUser(Request $request)
    {

        $stripeToken = $request->get('stripe_token');
        $user = Auth::user();
        $user->newSubscription($request->get('stripe_plan_id'), $request->get('stripe_plan_price'))->create($stripeToken);

        $accessToken = Auth::user()->token();

        DB::table('users')
        ->where('id', $accessToken->user_id)
        ->update(

            array( 
                "premuim" => true,
                "pack_name" => request('pack_name'),
                "pack_id" => request('stripe_plan_id'),
                "start_at" => request('start_at'),
                "type" => 'stripe',
                "expired_in" => Carbon::now()->addDays(request('pack_duration')))

        );

        return response()->json($user, 204);

    }



    public function cancelSubscription(Request $request)
{
    // Inicia a transação do banco de dados
    DB::beginTransaction();
    
    try {
        $user = Auth::user(); // Acessa o usuário autenticado uma única vez

        if (!$user->subscription($user->pack_id)->exists()) {
            return response()->json(['error' => 'Subscription not found.'], 404);
        }

        // Cancela a assinatura no Stripe
        $user->subscription($user->pack_id)->cancelNow();

        // Atualiza o registro do usuário no banco de dados
        DB::table('users')->where('id', $user->id)->update([
            "premuim" => false,
            "pack_name" => null, // Use null para campos vazios
            "start_at" => null,
            "type" => null,
            "expired_in" => Carbon::now(),
        ]);

        DB::commit(); // Confirma as operações no banco de dados

        return response()->json(null, 204); // Retorna resposta sem conteúdo
    } catch (Exception $e) {
        DB::rollBack(); // Reverte as operações em caso de erro
        // Log do erro para futura análise (opcional)
        // Log::error($e->getMessage());

        return response()->json(['error' => 'Failed to cancel subscription.'], 500);
    }
}

    public function cancelSubscriptionPaypal(Request $request)
    {

 
       $user = Auth::user();

        $accessToken = Auth::user()->token();

        DB::table('users')
        ->where('id', $accessToken->user_id)
        ->update(

            array( 
                "premuim" => false,
                "pack_name" => "",
                "start_at" => "",
                "type" => "",
                "expired_in" => Carbon::now())

        );

        return $request->user();

    }



    public function profile(Request $request)
    {

        $user = User::find(1);
        $user->subscribedTo("1");

        return response()->json($user, 204);

    }



    public function update_avatar(Request $request){

        $request->validate([
            'avatar' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',
        ]);

        $user = Auth::user();

        if (Storage::disk('avatars')->exists($user->avatar)) {

         Storage::delete($user->avatar);
  
        }

        $avatarName = $user->id.'_avatar.'.request()->avatar->getClientOriginalExtension();

        $request->avatar->storeAs('avatars',$avatarName);

        $user->avatar = $request->root() . '/api/avatars/image/' . $avatarName;
        $user->save();

        return response()->json([], 204);

    }



    public function updateAvatarProfile(Request $request){

        $request->validate([
            'avatar' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:1024',
            'id' => 'required',
            'id2' => 'required'
        ]);

        $user = Auth::user();


        $avatarName = $request->id2.'_avatar.'.request()->avatar->getClientOriginalExtension();

        $request->avatar->storeAs('avatars',$avatarName);


        DB::table('profiles')
        ->where('id',$request->id)
        ->update(
            array( 
                "avatar" => $request->root() . '/api/avatars/image/' . $avatarName));

        return response()->json("Success", 200);

    }


    public function user (Request $request){
        
        return $request->user();
     }


    public function logout(Request $request)
    {

        $accessToken = Auth::user()->token();

        $users = DB::select('select * from oauth_refresh_tokens');
        DB::delete('delete from oauth_refresh_tokens where id = ?',[$accessToken->id]);
        

        return response()->json([], 204);

    }


    public function deleteUser(Request $request)
    {

        $accessToken = Auth::user();

        if ($accessToken != null) {

         User::find($accessToken->id)->delete();

            $data = ['status' => 200, 'message' => 'successfully deleted',];
        } else {
            
            $data = ['status' => 400, 'message' => 'could not be deleted',];
        }

        
        return response()->json($data, 200);


    }



    public function getImg($filename)
    {

        $image = Storage::disk('avatars')->get($filename);

        $mime = Storage::disk('avatars')->mimeType($filename);

        return (new Response($image, 200))->header('Content-Type', $mime);
    }



    
}
