<?php

namespace App\Exports;

use App\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class UsersEmailExport implements FromCollection, WithHeadings
{
    private $limit;
    private $offset;

    public function __construct(int $limit, int $offset)
    {
        $this->limit = $limit;
        $this->offset = $offset;
    }

    public function collection()
    {
        return User::where('premuim', 0)->select('email')->skip($this->offset)->take($this->limit)->get();
    }


    public function headings(): array
    {
        return ['Email'];
    }
}

