<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\User;
use App\Movie;
use App\Serie;
use App\Anime;

class ContinueWatching extends Model
{
    protected $table = 'continue_watching';

    protected $fillable = [
        'profile_id',
        'user_id',
        'item_id',
        'type',
        'position',         // Adicionando campo para guardar posição do vídeo
        'duration',         // Adicionando campo para duração total do vídeo
        'episode_id',       // Para séries e animes, armazenar o ID do episódio
        'season_number',    // Para séries e animes, armazenar o número da temporada
        'episode_number'    // Para séries e animes, armazenar o número do episódio
    ];

    public function profile()
    {
        return $this->belongsTo('App\Profile', 'profile_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function movie()
    {
        return $this->belongsTo(Media::class, 'item_id')->where('type', 'movie');
    }

    public function serie()
    {
        return $this->belongsTo(Media::class, 'item_id')->where('type', 'serie');
    }

    public function anime()
    {
        return $this->belongsTo(Media::class, 'item_id')->where('type', 'anime');
    }

    public function episode()
    {
        return $this->belongsTo(Episode::class, 'episode_id');
    }

    // Calcular progresso como propriedade acessível
    public function getProgressAttribute()
    {
        if ($this->duration > 0) {
            return min(100, round(($this->position / $this->duration) * 100));
        }
        return 0;
    }

    // Escopo para filtrar por perfil
    public function scopeForProfile($query, $profileId)
    {
        return $query->where('profile_id', $profileId);
    }

    // Não permite timestamps padrão, já que gerenciamos updated_at manualmente
    public $timestamps = true;
}

