<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Http\Request;
use App\MovieVideo;
use App\Movie;
use BackblazeB2\Client;
use BackblazeB2\Bucket;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use App\Genre;
use App\Cast;
use App\MovieGenre;
use App\MovieCast;

class UpdateMovieLinks extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:movie-links';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update movie links from Backblaze';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $accountId = '00517533f925c8f0000000002';
        $applicationKey = 'K005b3uS0ailz8gkjU6itmzBHm9hndc';
        $bucketId = '7107f533f3af690285ac081f';
        $bucketName = 'utxgmpx';

        // Criar um cliente Backblaze B2
        $client = new Client($accountId, $applicationKey);

        // Listar todos os arquivos dentro do bucket, incluindo subpastas
        $fileList = $client->listFiles([
            'BucketId' => $bucketId
        ]);

        $filteredFiles = array_filter($fileList, function($file) {
            return strpos($file->getName(), 'f/') === 0;
        });
        
        Movie::query()->update(['active' => 1]);

        $unlinkedFiles = [];

        foreach ($filteredFiles as $file) {
            $fileName = $file->getName();
            
            // Extrair o tmdb_id do nome do arquivo
            preg_match('/_(\d+)\.mp4$/', $fileName, $matches);
            $tmdb_id_in_file = $matches[1] ?? null;
        
            if ($tmdb_id_in_file) {
                // Obter o filme usando o tmdb_id
                $movie = Movie::where('tmdb_id', $tmdb_id_in_file)->first();
        
                if ($movie) {
                    // dump("Filme encontrado: " . $movie->id);
        
                    // Construir a URL do arquivo
                    $bucket_url = 'https://v.baixarfree.com/file/'. $bucketName . '/' . $fileName;

                    // dump($fileName);
        
                    // Procurar se o vídeo já existe na tabela
                    $existingVideo = MovieVideo::where('movie_id', $movie->id)->where('server', 'Servidor 1')->first();
        
                    if ($existingVideo) {
                        // Atualizar o link existente
                        $existingVideo->update(['link' => $bucket_url]);
                    } else {
                        // Criar novo registro
                        MovieVideo::create([
                            'movie_id' => $movie->id,
                            'link' => $bucket_url,
                            'server' => 'Servidor 1' // Adicionando um servidor, como no seu exemplo
                        ]);
                    }
                } else {
                    $unlinkedFiles[] = $file->getName(); // Adiciona o nome do arquivo à lista
                    // dump($unlinkedFiles);
                }
            }
        }

        $movieIdsWithLinks = MovieVideo::distinct()->pluck('movie_id')->toArray();

        // Marcar como inativos todos os filmes que não têm um link na tabela MovieVideo
        Movie::whereNotIn('id', $movieIdsWithLinks)->update(['active' => 0]);

        $inactiveMovies = Movie::where('active', 0)->get();

        // dump($inactiveMovies->first());


        // Criar um arquivo .txt com os IDs desses filmes
        $txtContent = "";
        foreach ($inactiveMovies as $movie) {
            $txtContent .= "ID: " . $movie->id . " | Nome: " . $movie->title . " | TMDB_ID: " . $movie->tmdb_id . PHP_EOL;
        }

        // dump($txtContent);

        // Gerar o arquivo .txt
        $filePath = storage_path('inactive_movies.txt');
        file_put_contents($filePath, $txtContent);

        // Fazer o upload para o Backblaze
        $fileContent = file_get_contents($filePath);
        $fileNameOnBackblaze = 'filmes-semlink-inativos.txt';

        $client->upload([
            'BucketId' => $bucketId,
            'FileName' => $fileNameOnBackblaze,
            'Body' => $fileContent,
        ]);

        // Excluir o arquivo .txt local, se desejado
        unlink($filePath);


        $txtUnlinkedFilesContent = implode(PHP_EOL, $unlinkedFiles);
        dump($txtUnlinkedFilesContent);

        // Gerar o arquivo .txt
        $filePathUnlinkedFiles = storage_path('unlinked_files.txt');
        file_put_contents($filePathUnlinkedFiles, $txtUnlinkedFilesContent);

        // Fazer o upload para o Backblaze
        $fileUnlinkedContent = file_get_contents($filePathUnlinkedFiles);
        $fileNameOnBackblazeUnlinked = 'arquivos-nao-associados.txt';

        $client->upload([
            'BucketId' => $bucketId,
            'FileName' => $fileNameOnBackblazeUnlinked,
            'Body' => $fileUnlinkedContent,
        ]);

        // Excluir o arquivo .txt local, se desejado
        unlink($filePathUnlinkedFiles);
        
        

        // dump($movie);
        return Command::SUCCESS;
    }
}
