<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\UsuarioSorteio;
use Log;

class DeleteNonPremiumUsers extends Command
{
    protected $signature = 'users:delete-non-premium';
    protected $description = 'Delete non-premium users from the sorteo table';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        Log::info('DeleteNonPremiumUsers Command Started');
    
        $usuariosParaExcluir = UsuarioSorteio::whereHas('user', function ($query) {
            $query->where('premuim', '!=', 1);
        })->get();
    
        Log::info('Users to delete: ' . $usuariosParaExcluir->count());
    
        foreach ($usuariosParaExcluir as $usuario) {
            $usuario->delete();
        }
    
        Log::info('DeleteNonPremiumUsers Command Finished');
    }
}
