<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\MovieVideo;
use App\SerieVideo;
use App\AnimeVideo;
use Illuminate\Support\Facades\DB;

class CleanNonUltraEmbedLinks extends Command
{
    protected $signature = 'videos:clean-non-ultraembed';
    protected $description = 'Remove todos os links que não são do ultraembed.com';

    public function handle()
    {
        $this->info('Iniciando limpeza de links não-UltraEmbed...');

        try {
            DB::beginTransaction();

            // Limpa MovieVideos
            $movieCount = MovieVideo::where('link', 'not like', '%ultraembed.com%')->count();
            
            if ($movieCount > 0) {
                $this->info("Encontrados {$movieCount} links não-UltraEmbed em filmes.");
                
                MovieVideo::where('link', 'not like', '%ultraembed.com%')
                    ->chunkById(100, function ($videos) {
                        foreach ($videos as $video) {
                            $video->delete();
                        }
                    });
                
                $this->info("✓ {$movieCount} links de filmes removidos com sucesso.");
            } else {
                $this->info("Nenhum link não-UltraEmbed encontrado em filmes.");
            }

            // Limpa SerieVideos
            $serieCount = SerieVideo::where('link', 'not like', '%ultraembed.com%')->count();
            
            if ($serieCount > 0) {
                $this->info("Encontrados {$serieCount} links não-UltraEmbed em séries.");
                
                SerieVideo::where('link', 'not like', '%ultraembed.com%')
                    ->chunkById(100, function ($videos) {
                        foreach ($videos as $video) {
                            $video->delete();
                        }
                    });
                
                $this->info("✓ {$serieCount} links de séries removidos com sucesso.");
            } else {
                $this->info("Nenhum link não-UltraEmbed encontrado em séries.");
            }
            
            // Limpa AnimeVideos
            $animeCount = AnimeVideo::where('link', 'not like', '%ultraembed.com%')->count();
            
            if ($animeCount > 0) {
                $this->info("Encontrados {$animeCount} links não-UltraEmbed em animes.");
                
                AnimeVideo::where('link', 'not like', '%ultraembed.com%')
                    ->chunkById(100, function ($videos) {
                        foreach ($videos as $video) {
                            $video->delete();
                        }
                    });
                
                $this->info("✓ {$animeCount} links de animes removidos com sucesso.");
            } else {
                $this->info("Nenhum link não-UltraEmbed encontrado em animes.");
            }

            DB::commit();

            $this->table(
                ['Tipo', 'Links Removidos'],
                [
                    ['Filmes', $movieCount],
                    ['Séries', $serieCount],
                    ['Animes', $animeCount],
                    ['Total', $movieCount + $serieCount + $animeCount]
                ]
            );
        } catch (\Exception $e) {
            DB::rollBack();
            $this->error("Erro durante a limpeza: " . $e->getMessage());
            return 1;
        }

        $this->info("\nProcesso de limpeza concluído com sucesso!");
        return 0;
    }
}