<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;
use App\Mail\RenewalReminderEmail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class CheckExpiredSubscriptions extends Command
{
    protected $signature = 'subscriptions:check-expired';
    protected $description = 'Check for expired subscriptions and send reminder emails';

    public function handle()
    {
        
        $users = User::whereNotNull('expired_in')
             ->where('expired_in', '<', Carbon::now())
             ->get();

        foreach ($users as $user) {
            Mail::to($user->email)->send(new RenewalReminderEmail($user));
        }

        $this->info('Reminder emails sent successfully.');
    }
}
