<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Serie;
use App\SerieVideo;

class AddUltraEmbedSeriesLinks extends Command
{
    protected $signature = 'series:add-ultraembed';
    protected $description = 'Adiciona links do UltraEmbed para todas as séries e seus episódios';

    public function handle()
    {
        $totalSeries = Serie::whereNotNull('tmdb_id')->count();
        $seriesProcessadas = 0;
        
        $this->info("Total de séries encontradas: {$totalSeries}");
        $bar = $this->output->createProgressBar($totalSeries);

        // Processa as séries em chunks de 10
        Serie::whereNotNull('tmdb_id')
            ->select('id', 'tmdb_id', 'name')
            ->chunk(10, function($series) use (&$seriesProcessadas, $bar) {
                foreach ($series as $serie) {
                    // Carrega as temporadas e episódios para cada série individualmente
                    $seasons = $serie->seasons()->with('episodes')->get();
                    
                    foreach ($seasons as $season) {
                        foreach ($season->episodes as $episode) {
                            // Gera o link do UltraEmbed
                            $ultraembedLink = sprintf(
                                "https://ultraembed.com/serie/%s/%d/%d/direct/VBBp8OkaaR5zwM3aWT5HgB9sdmsPlf9pykwmbPbpJz0s5H60IxKlmK4F1Ul7fSq2",
                                $serie->tmdb_id,
                                $season->season_number,
                                $episode->episode_number
                            );

                            // Cria o registro de vídeo para o episódio
                            SerieVideo::create([
                                'episode_id' => $episode->id,
                                'server' => 'Servidor 1',
                                'link' => $ultraembedLink,
                                'hls' => 1,
                                'embed' => 1
                            ]);
                        }
                    }
                    
                    $seriesProcessadas++;
                    $bar->advance();

                    // Limpa a memória
                    unset($seasons);
                }
            });
        
        $bar->finish();
        
        $this->info("\nProcesso concluído!");
        $this->info("Séries processadas com sucesso: {$seriesProcessadas}/{$totalSeries}");
    }
}