<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Movie;
use App\Serie;
use App\Anime;
use App\MovieVideo;
use App\SerieVideo;
use App\AnimeVideo;

class AddAllUltraEmbedLinks extends Command
{
    protected $signature = 'videos:add-ultraembed {--type=all} {--chunk=10}';
    protected $description = 'Adiciona links do UltraEmbed para filmes, séries e animes. Use --type=movies|series|animes para processar específicos';

    private $apiKey = 'VBBp8OkaaR5zwM3aWT5HgB9sdmsPlf9pykwmbPbpJz0s5H60IxKlmK4F1Ul7fSq2';

    public function handle()
    {
        $type = $this->option('type');
        $chunkSize = $this->option('chunk');

        $this->info('Iniciando adição de links UltraEmbed...');

        if (in_array($type, ['all', 'movies'])) {
            $this->processMovies();
        }

        if (in_array($type, ['all', 'series'])) {
            $this->processSeries($chunkSize);
        }

        if (in_array($type, ['all', 'animes'])) {
            $this->processAnimes($chunkSize);
        }

        $this->info("\nProcesso concluído com sucesso!");
    }

    private function processMovies()
    {
        $this->info("\nProcessando Filmes...");
        
        $movies = Movie::whereNotNull('tmdb_id')->get();
        $bar = $this->output->createProgressBar(count($movies));

        foreach ($movies as $movie) {
            try {
                $ultraembedLink = sprintf(
                    "https://ultraembed.com/filme/%s/direct/%s",
                    $movie->tmdb_id,
                    $this->apiKey
                );

                MovieVideo::create([
                    'movie_id' => $movie->id,
                    'server' => 'Servidor 1',
                    'link' => $ultraembedLink,
                    'hls' => 1,
                    'status' => 1,
                ]);

                $bar->advance();
            } catch (\Exception $e) {
                $this->error("\nErro ao processar filme {$movie->id}: " . $e->getMessage());
            }
        }

        $bar->finish();
        $this->info("\nFilmes processados!");
    }

    private function processSeries($chunkSize)
    {
        $this->info("\nProcessando Séries...");
        
        $totalSeries = Serie::whereNotNull('tmdb_id')->count();
        $processedCount = 0;
        
        $bar = $this->output->createProgressBar($totalSeries);

        Serie::whereNotNull('tmdb_id')
            ->select('id', 'tmdb_id', 'name')
            ->chunk($chunkSize, function($series) use (&$processedCount, $bar) {
                foreach ($series as $serie) {
                    try {
                        $seasons = $serie->seasons()->with('episodes')->get();
                        
                        foreach ($seasons as $season) {
                            foreach ($season->episodes as $episode) {
                                $ultraembedLink = sprintf(
                                    "https://ultraembed.com/serie/%s/%d/%d/direct/%s",
                                    $serie->tmdb_id,
                                    $season->season_number,
                                    $episode->episode_number,
                                    $this->apiKey
                                );

                                SerieVideo::create([
                                    'episode_id' => $episode->id,
                                    'server' => 'Servidor 1',
                                    'link' => $ultraembedLink,
                                    'hls' => 1,
                                ]);
                            }
                        }

                        $processedCount++;
                        $bar->advance();
                        unset($seasons);
                    } catch (\Exception $e) {
                        $this->error("\nErro ao processar série {$serie->name}: " . $e->getMessage());
                    }
                }
            });

        $bar->finish();
        $this->info("\nSéries processadas: {$processedCount}/{$totalSeries}");
    }

    private function processAnimes($chunkSize)
    {
        $this->info("\nProcessando Animes...");
        
        $totalAnimes = Anime::whereNotNull('tmdb_id')->count();
        $processedCount = 0;
        
        $bar = $this->output->createProgressBar($totalAnimes);

        Anime::whereNotNull('tmdb_id')
            ->select('id', 'tmdb_id', 'name')
            ->chunk($chunkSize, function($animes) use (&$processedCount, $bar) {
                foreach ($animes as $anime) {
                    try {
                        $seasons = $anime->seasons()->with('episodes')->get();
                        
                        foreach ($seasons as $season) {
                            foreach ($season->episodes as $episode) {
                                $ultraembedLink = sprintf(
                                    "https://ultraembed.com/serie/%s/%d/%d/direct/%s",
                                    $anime->tmdb_id,
                                    $season->season_number,
                                    $episode->episode_number,
                                    $this->apiKey
                                );

                                AnimeVideo::create([
                                    'anime_episode_id' => $episode->id,
                                    'server' => 'Servidor 1',
                                    'link' => $ultraembedLink,
                                    'hls' => 1,
                                ]);
                            }
                        }

                        $processedCount++;
                        $bar->advance();
                        unset($seasons);
                    } catch (\Exception $e) {
                        $this->error("\nErro ao processar anime {$anime->name}: " . $e->getMessage());
                    }
                }
            });

        $bar->finish();
        $this->info("\nAnimes processados: {$processedCount}/{$totalAnimes}");
    }
}