<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Anime;
use App\AnimeVideo;

class AddUltraEmbedAnimeLinks extends Command
{
    protected $signature = 'animes:add-ultraembed';
    protected $description = 'Adiciona links do UltraEmbed para todos os animes e seus episódios';

    public function handle()
    {
        $totalSeries = Anime::whereNotNull('tmdb_id')->count();
        $seriesProcessadas = 0;
        
        $this->info("Total de animes encontrados: {$totalSeries}");
        $bar = $this->output->createProgressBar($totalSeries);

        // Processa os animes em chunks de 10
        Anime::whereNotNull('tmdb_id')
            ->select('id', 'tmdb_id', 'name')
            ->chunk(10, function($animes) use (&$seriesProcessadas, $bar) {
                foreach ($animes as $anime) {
                    try {
                        // Carrega as temporadas e episódios para cada anime individualmente
                        $seasons = $anime->seasons()->with('episodes')->get();
                        
                        foreach ($seasons as $season) {
                            foreach ($season->episodes as $episode) {
                                // Gera o link do UltraEmbed
                                $ultraembedLink = sprintf(
                                    "https://ultraembed.com/serie/%s/%d/%d/direct/VBBp8OkaaR5zwM3aWT5HgB9sdmsPlf9pykwmbPbpJz0s5H60IxKlmK4F1Ul7fSq2",
                                    $anime->tmdb_id,
                                    $season->season_number,
                                    $episode->episode_number
                                );

                                // Cria o registro de vídeo para o episódio
                                AnimeVideo::create([
                                    'anime_episode_id' => $episode->id, // Corrigido para anime_episode_id
                                    'server' => 'Servidor 1',
                                    'link' => $ultraembedLink,
                                    'hls' => 1,
                                    'embed' => 1
                                ]);
                            }
                        }
                        
                        $seriesProcessadas++;
                        $bar->advance();

                        // Limpa a memória
                        unset($seasons);
                    } catch (\Exception $e) {
                        $this->error("Erro ao processar anime {$anime->name}: " . $e->getMessage());
                        continue;
                    }
                }
            });
        
        $bar->finish();
        
        $this->info("\nProcesso concluído!");
        $this->info("Animes processados com sucesso: {$seriesProcessadas}/{$totalSeries}");
    }
}